Triggers = {}

include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/end_trigger")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/kill_watcher")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/quest_watcher")

Triggers["center_point"] = 
{
	active = false, 
	effect_radius = 20, 
	position = { x = -13.56, y = -6.29, z = 15.9, f = 1.0}, 
	priority = 1.0, 
	think = "tf_center_point", 
	type = "quest", 
}

Triggers["emergency_exit"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_emergency_exit", 
	type = "quest", 
}

Triggers["ambush"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_ambush", 
	type = "quest", 
}

Triggers["spawn_ambushers"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_spawn_ambushers", 
	type = "quest", 
}

trigger_functions =
{
tf_ambush = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	
	if(trigger.active == true) then
		if (IsAlive("ambush_1")) then
			local cm = getClosestMerc("ambush_1", CUR_MISSION.Mercs)
			if (service.person2person_distance("ambush_1", cm) < 5) then
				trigger.active = false
				startDlg("Ambush", cm, "ambush_1")
			end
		else
			trigger.active = false
			Triggers["spawn_ambushers"].active = true
		end
	end
end,
tf_spawn_ambushers = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	
	if(trigger.active == true) then
		trigger.active = false
		changeLocalRelations(ENEMY, CORP)
		for count = 4, 13, 1 do
			spawnHuman(CORP, "ambush_"..tostring(count))
		end
	end
end,
tf_emergency_exit = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
		finishMission(false)
	end
end,
--
-- end trigger
--
tf_end_trigger = CommonTriggers.end_trigger,
--
-- kill watcher trigger
--
tf_kill_watcher = CommonTriggers.kill_watcher,
--
-- quest watcher trigger
--
tf_quest_watcher = CommonTriggers.quest_watcher,
--
-- honey point for bees
--
tf_center_point = CommonTriggers.center_point,
}

